// Timer Objerct //

function Timer(length)
{
	this.time = 0;
	this.length = length;
	this.onEnd = function(){};
	this.paused = true;
}

Timer.prototype.blit = function(x, y)
{
	if (this.time == 0) GameStyle.drawText(x, y, "--");
	else GameStyle.drawText(x, y, Math.round(((this.time+this.length)-GetTime())/1000));
}

Timer.prototype.start = function()
{
	this.paused = false;
	this.time = GetTime();
}

Timer.prototype.update = function()
{
	if (this.paused) return;
	if (this.time + this.length < GetTime())
	{
		this.time = 0;
		this.onEnd();
	}
}

Timer.prototype.pause = function()
{
	this.paused = true;
}

Timer.prototype.resume = function()
{
	this.time = this.time + (GetTime() - this.time)/2;
	this.paused = false;
}

Timer.prototype.reset = function(length)
{
	this.time = 0;
	this.length = length;
	this.paused = true;
}